"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dollarsToCents = exports.PLANS = void 0;
const stripe_1 = __importDefault(require("stripe"));
exports.PLANS = {
    "voice-ai-monthly": {
        price_id: process.env.VOICE_AI_MONTHLY_PRICE_KEY,
    },
    "voice-ai-yearly": {
        price_id: process.env.VOICE_AI_YEARLY_PRICE_KEY,
    },
    "text-ai-monthly": {
        price_id: process.env.TEXT_AI_MONTHLY_PRICE_KEY,
    },
    "text-ai-yearly": {
        price_id: process.env.TEXT_AI_YEARLY_PRICE_KEY,
    },
};
const stripeSecretKey = process.env.STRIPE_SECRET_KEY;
if (!stripeSecretKey) {
    throw new Error("Stripe secret key is missing in environment variables" + stripeSecretKey);
}
// Initialize Stripe
const stripe = new stripe_1.default(stripeSecretKey, {
    apiVersion: "2025-02-24.acacia",
});
// Helper function to convert dollars to cents
const dollarsToCents = (amountInDollars) => {
    return Math.round(amountInDollars * 100);
};
exports.dollarsToCents = dollarsToCents;
exports.default = stripe;
