"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const body_parser_1 = __importDefault(require("body-parser"));
const subscriptionController = __importStar(require("../controllers/subscriptionController"));
const asyncHandler_1 = require("../middleware/asyncHandler");
const subscriptionsRouter = (0, express_1.Router)();
// Create a subscription with a setup fee
subscriptionsRouter.post("/subscribe", (0, asyncHandler_1.asyncHandler)(subscriptionController.createSubscription));
// Cancel a subscription
subscriptionsRouter.post("/cancel", (0, asyncHandler_1.asyncHandler)(subscriptionController.cancelSubscription));
// Fetch all subscriptions for a user
subscriptionsRouter.get("/:userId/subscriptions", (0, asyncHandler_1.asyncHandler)(subscriptionController.getUserSubscriptions));
// Fetch all canceled subscriptions for a user
subscriptionsRouter.get("/:userId/canceled-subscriptions", (0, asyncHandler_1.asyncHandler)(subscriptionController.getUserCanceledSubscriptions));
// Retrieve subscription details
subscriptionsRouter.get("/:subscriptionId", (0, asyncHandler_1.asyncHandler)(subscriptionController.getSubscriptionDetails));
// Get payment method for a user
subscriptionsRouter.get("/:userId/payment-method", (0, asyncHandler_1.asyncHandler)(subscriptionController.getUserPaymentMethod));
// Remove payment method for a user
subscriptionsRouter.post("/:userId/remove-payment-method", (0, asyncHandler_1.asyncHandler)(subscriptionController.removeUserPaymentMethod));
// Get invoices for a user
subscriptionsRouter.get("/:userId/invoices", (0, asyncHandler_1.asyncHandler)(subscriptionController.getUserInvoices));
// Switch subscription plan
subscriptionsRouter.post("/switch-plan", (0, asyncHandler_1.asyncHandler)(subscriptionController.switchSubscriptionPlan));
// Webhook endpoint for Stripe events
subscriptionsRouter.post("/webhook", body_parser_1.default.raw({ type: "application/json" }), (0, asyncHandler_1.asyncHandler)(subscriptionController.handleStripeWebhook));
// Update payment method for a user
// subscriptionsRouter.post(
//   "/:userId/update-payment-method",
//   asyncHandler(subscriptionController.updatePaymentMethod)
// );
// subscriptionsRouter.post(
//   "/:userId/create-setup-intent",
//   asyncHandler(subscriptionController.createSetupIntent)
// );
subscriptionsRouter.post("/:userId/setup-payment-method", (0, asyncHandler_1.asyncHandler)(subscriptionController.setupPaymentMethod));
exports.default = subscriptionsRouter;
