"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const calendarController_1 = require("../controllers/calendarController");
const isAuth_1 = __importDefault(require("../middleware/isAuth"));
const router = express_1.default.Router();
router.get('/connect', isAuth_1.default, calendarController_1.checkConnectedCalendars);
// Google Calendar connection routes
router.get('/google/connect', isAuth_1.default, calendarController_1.connectGoogleCalendar);
router.get('/google/callback', calendarController_1.handleGoogleCalendarCallback);
// Calendar events routes
router.post('/events/create', isAuth_1.default, calendarController_1.createCalendarEvent);
router.get('/events/fetch', isAuth_1.default, calendarController_1.fetchCalendarEvents);
router.put('/events/update/:eventId', isAuth_1.default, calendarController_1.updateCalendarEvent);
router.delete('/events/delete/:eventId', isAuth_1.default, calendarController_1.deleteCalendarEvent);
exports.default = router;
