"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class User extends sequelize_1.Model {
}
User.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
    },
    email: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
        // unique: true,
    },
    password: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    name: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    profile_url: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    company: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    jobTitle: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    organization_id: {
        type: sequelize_1.DataTypes.UUID,
        allowNull: true,
        references: {
            model: 'Organization',
            key: 'organization_id',
        },
    }
}, {
    sequelize: database_1.default,
    modelName: 'User',
    tableName: 'Users',
});
// User.hasMany(Subscription, { foreignKey: 'userId', as: 'subscription' });
// Subscription.belongsTo(User, { foreignKey: 'userId' });
// User.hasOne(Organization, { foreignKey: 'owner_user_id', as: 'Organization' });
// Organization.belongsTo(User, { foreignKey: 'owner_user_id', as: 'owner' });
exports.default = User;
