"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class CallLog extends sequelize_1.Model {
}
CallLog.init({
    call_log_id: {
        type: sequelize_1.DataTypes.UUID,
        defaultValue: sequelize_1.DataTypes.UUIDV4,
        primaryKey: true,
    },
    organization_id: {
        type: sequelize_1.DataTypes.UUID,
        allowNull: false,
        references: { model: 'Organization', key: 'organization_id' },
    },
    assistant_config_id: {
        type: sequelize_1.DataTypes.UUID,
        defaultValue: sequelize_1.DataTypes.UUIDV4,
        allowNull: true,
        references: { model: 'AssistantConfigurations', key: 'assistant_config_id' },
    },
    api_credential_id_used: {
        type: sequelize_1.DataTypes.UUID,
        allowNull: true,
        references: { model: 'ApiCredentials', key: 'api_credential_id' },
    },
    vapi_call_id_external: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
        unique: true,
    },
    status: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    direction: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    caller_number: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    destination_number: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    start_time: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: true,
    },
    end_time: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: true,
    },
    duration_seconds: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: true,
    },
    cost_usd: {
        type: sequelize_1.DataTypes.DECIMAL,
        allowNull: true,
    },
    transcript_summary: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    full_transcript_storage_ref: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    recording_url_external: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    metadata_payload: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: true,
    },
    error_code: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    error_message: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    created_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updated_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: database_1.default,
    modelName: 'CallLog',
    tableName: 'CallLogs',
    timestamps: false,
    underscored: true,
});
exports.default = CallLog;
