"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class CalendarAccount extends sequelize_1.Model {
}
CalendarAccount.init({
    id: {
        type: sequelize_1.DataTypes.UUID,
        defaultValue: sequelize_1.DataTypes.UUIDV4,
        primaryKey: true,
    },
    user_id: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: 'Users',
            key: 'id',
        },
    },
    provider: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    email: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    access_token: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: false,
    },
    refresh_token: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: false,
    },
    expires_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
    },
    scope: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    is_primary: {
        type: sequelize_1.DataTypes.BOOLEAN,
        defaultValue: true,
    },
    status: {
        type: sequelize_1.DataTypes.STRING,
        defaultValue: 'active',
    },
    calendar_id: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
        defaultValue: 'primary',
    },
    display_name: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    time_zone: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
        defaultValue: 'Asia/Karachi',
    },
    last_sync_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: true,
    },
    sync_token: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    error_count: {
        type: sequelize_1.DataTypes.INTEGER,
        defaultValue: 0,
    },
    last_error: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    created_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updated_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: database_1.default,
    modelName: 'CalendarAccount',
    tableName: 'calendar_accounts',
    timestamps: false,
});
exports.default = CalendarAccount;
