"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class AssistantConfiguration extends sequelize_1.Model {
}
AssistantConfiguration.init({
    assistant_config_id: {
        type: sequelize_1.DataTypes.UUID,
        defaultValue: sequelize_1.DataTypes.UUIDV4,
        primaryKey: true,
    },
    organization_id: {
        type: sequelize_1.DataTypes.UUID,
        allowNull: false,
        references: {
            model: 'Organization',
            key: 'organization_id',
        },
    },
    name: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    description: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    first_message: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    system_prompt: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    llm_provider: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    llm_model: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    vapi_model_settings: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: false,
    },
    vapi_voice_settings: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: true,
    },
    transcriber_settings: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: true,
    },
    vapi_forwarding_phone_number: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    server_url_override: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    server_url_secret_override: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    vapi_assistant_id_external: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    metadata: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: false,
        defaultValue: {},
    },
    is_active: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
    },
    created_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updated_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: database_1.default,
    modelName: 'AssistantConfiguration',
    tableName: 'AssistantConfigurations',
    timestamps: false,
    underscored: true,
});
exports.default = AssistantConfiguration;
