"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const dotenv_1 = require("dotenv");
// Load env file based on NODE_ENV
(0, dotenv_1.config)({ path: `.env.${process.env.NODE_ENV || 'development'}.local` });
const { DB_NAME, DB_USER, DB_PASSWORD, DB_HOST } = process.env;
console.log('ENV HOST:', process.env.DB_HOST);
const sequelize = new sequelize_1.Sequelize(DB_NAME, DB_USER, DB_PASSWORD, {
    host: DB_HOST,
    dialect: 'mysql',
    logging: false,
});
console.log(`Connected to ${process.env.NODE_ENV} database`);
exports.default = sequelize;
